--NIGHTSTORM

local AIM_120B =
{
	category		= CAT_AIR_TO_AIR,
	name			= "AIM_120",
--	displayName		= _("AIM-120B AMRAAM - Active Radar AAM"),
--	user_name		= _("AIM-120B"),
--	display_name_short = "AIM-120",
	displayName		= _("AIM-120D AMRAAM - Active Rdr AAM"),		--NIGHTSTORM
	user_name		= _("AIM-120D"),		--NIGHTSTORM
	Picture			= "us_AIM-120D.png",	--NIGHTSTORM
	display_name_short = "AIM-120D",	--NIGHTSTORM	
	scheme			= "aa_missile_amraam2",
	class_name		= "wAmmunitionSelfHoming",
	model			= "aim-120b",
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,AIM_120},
	
	shape_table_data =
	{
		{
			file  = "aim-120b";
			life  = 1;
			fire  = {0, 1};
			name  	 = "AIM-120B";
			username = "AIM-120B";
			index 	 = AIM_120,
		},
	},
	
    Escort = 0,				--0-No, 1-La launch, 2-other La, 3-C ground
    Head_Type = 2,			--1-InfraredSeeker, 2-ActiveRadar, 3-AntiRadar, 4-Laserhooming, 5-Autopilot (GPS, TV, IIR), 6-SemiActiveRadar, 7-SemiAutoAT (control from platform)
	sigma = {1, 1, 1},		-- Sigma = {x, y, z}, maximum aiming error in meters, in target coordinates. X-longitudinal axis of the target, y-axis virtualna purpose, Z - axis, transverse target	--NIGHTSTORM {5, 5, 5},
    M = 161.48,				--Gross weight in kg
    H_max = 26000.0,		--Maximum flight altitude in meters. 18Km=59100feet 20km = 65600
    H_min = 1.0,			--Minimum flight height in meters.
    Diam = 178.0,			--Case Diameter in mm
    Cx_pil = 2.5,			--Cx as suspension (Drag value is assumed)		
    D_max = 74400.0,		--Maximum Launch range at low altitude in meters
    D_min = 500.0,			--Minimum Launch range at low altitude in meters
    Head_Form = 1,			--False - hemispherical head shape / True-animate (~conic)
    Life_Time = 200.0,		--Lifetime (self-destruct timer), sec		
    Nr_max = 40,			--Maximum overload during turns		--NIGHTSTORM 30,
    v_min = 140.0,			-- Minimum speed
    v_mid = 2200.0,			-- Average Speed
    Mach_max = 5.0,			--Maximum Mach number
    t_b = 0.5,				--Engine start time
    t_acc = 2.3,			--Time of operation of the accelerator
    t_marsh = 11.0,			--Operating time in marching mode	
    Range_max = 180000.0,	--Maximum launch range at maximum altitude in meters (97 NM)
    H_min_t = 1.0,			--Minimum height of the target above the terrain in meters		
    Fi_start = 0.88,		--Angle of tracking and sighting at launch (Angle off boresight)		--NIGHTSTORM 0.78
    Fi_rak = 3.14152,		--Acceptable angle of view of the target (radians)
    Fi_excort = 1.05,		--Angle of tracking (sight) of the target by the missile. (Gimbal Angle Limit)
    Fi_search = 1.05,		--Limit angle of free search (Field of View)
    OmViz_max = 0.70,		--Maximum line-of-sight speed (Gimbl Ang Rate Lim 63°/s)
    exhaust = {0.8, 0.8, 0.8, 0.05 };	--Exhaust definition
    X_back = -1.85,			--X coordinates of the nozzle center in the rocket axes 
    Y_back = 0.0,			--Y coordinates of the nozzle center in the rocket axes
    Z_back = 0.0,			--Z coordinates of the nozzle center in the rocket axes
    Reflection = 0.07,	--Effective radio reflection surface, square meters (RADAR cross section)  --NIGHTSTORM 0.0329
    KillDistance = 20.0,	--Distance is used to start the fuse	--NIGHTSTORM 15.0,
	SeekerGen = 4,  -- Seeker generation
	ccm_k0 = 0.001,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)		--NIGHTSTORM 0.2,
	loft = 1,				--Can missile loft to target based on range 0/1
	hoj = 1,				--Can missile home on an active jamming source 0/1
	loft_factor = 1.5,		--NIGHTSTORM Reduced loft factor from 4.5 for new seeker code to avoid overshoot.
	PN_gain = 6,		--NIGHTSTORM 4

		
	supersonic_A_coef_skew = 0.1, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.02322576, -- площадь выходного сечения сопла		--NIGHTSTORM 0.011,
		
	ModelData = {   58 ,  -- model params count
					0.5 ,   -- characteristic square (характеристическая площадь)
					
					-- параметры зависимости Сx
					0.026 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
					0.053 , -- Cx_k1 высота пика волнового кризиса
					0.01 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
					-0.245, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
					0.075 , -- Cx_k4 крутизна спада за волновым кризисом 
					0.7 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
						
					-- параметры зависимости Cy
					1.5 , -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
					0.6	 , -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
					1.2  , -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
					
					0.5 , -- 7 Alfa_max  максимальный балансировачный угол, радианы
					0.0, --угловая скорость создаваймая моментом газовых рулей
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end		-- Stage
						-1.0,	   	0.5,	2.3,		11.0,		0.0,			0.0,		1.0e9,		-- time of stage, sec
						 0.0,		0.0,	8.8,		4.08,		0.0,			0.0,		0.0,		-- fuel flow rate in second, kg/sec
						 0.0,		0.0,	20392.9,	9360.4,		0.0,			0.0,		0.0,		-- thrust, newtons
					
						 1.0e9, -- таймер самоликвидации, сек
						 200.0, -- lifetime in seconds							 
						 0, -- Minimum height in M
						 0.5, -- Autopilot delay, sec
						 60000.0, -- Lofting logic Rmin 
						 80000.0, -- Range to target at which loft is complete (must be larger than previous value) in meters
						 0.42356,	-- Angle in radians of loft 	--NIGHTSTORM  52356
						 30.0, -- longitudinal acceleration of fuse cocking
						 0.0, -- speed module communicated by a catapult device, expelling charge, etc.
						 1.19, -- characteristic of the SAU-RAKETA system, second-order filter coefficient K0
						 1.0, -- characteristic of the SAU-Raketa system, second order filter coefficient K1
						 2.0, -- characteristic of the SAU-RAKETA system, control loop bandwidth

					  -- DLZ. Data for calculating launch ranges (indication on the sight)
						21.0, 		-- range with respect to carrier speed at an altitude of 1 km
						-23.0, 		-- range with respect to target speed at an altitude of 1 km
						-3.0, 		-- derivative with respect to height of derivative of range with respect to target speed
						109200, 	-- range angle 180 degrees (towards), H = 5,000m, V = 900km / h, m	H = 16,404ft V = 486kts
						37200, 		-- range angle 0 (in pursuit) deg, H = 5,000m, V = 900km / h, m  H = 16,404ft V = 486kts
						180000,		-- range angle 180 (towards) deg, H = 10,000m, V = 900km / h, m  H = 32,808ft, V = 486kts
						70800, 		-- range angle 0 (in pursuit) deg, H = 10,000m, V = 900km / h, m  H = 32,808ft, V = 486kts
						74400, 		-- range angle 180 (towards) deg, H = 1,000m, V = 900km / h, m  H = 3,281ft, V = 486kts
						21600, 		-- range angle 0 (in pursuit) deg, H = 1,000m, V = 900km / h, m  H = 3,281ft, V = 486kts
						4000, 		-- backward offset from the backsight point of the reachable zone
						0.4, 		-- percentage of guaranteed range from range in PPS at an altitude of 1 km
						-0.015, 	-- derivative of the percentage of guaranteed range in PPP by height
						0.5,		-- Changing the slope coefficients of the curve in the upper and lower hemispheres from the height of the carrier.

				},
				
	controller = {
		boost_start = 0.5,
		march_start = 2.8,
	},
	
--Thrust value = impulse x fuel mass x 9.8 / burn time  

	boost = {
		impulse								= 236,
		fuel_mass							= 20.28,
		work_time							= 2.3,
		nozzle_position						= {{-1.9, 0, 0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		nozzle_exit_area 					= 0.02322576,
		tail_width							= 0.4,
		smoke_color							= {0.8, 0.8, 0.8},
		smoke_transparency					= 0.03,
		custom_smoke_dissipation_factor		= 0.2,
		smoke_opacity_type 					= 1,
	},

	march = {
		impulse								= 234,
		fuel_mass							= 44.9,
		work_time							= 11,
		nozzle_position						= {{-1.9, 0, 0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		nozzle_exit_area 					= 0.02322576,
		tail_width							= 0.4,
		smoke_color							= {0.8, 0.8, 0.8},
		smoke_transparency					= 0.03,
		custom_smoke_dissipation_factor		= 0.2,
		smoke_opacity_type 					= 1,		
	},	

	fm = {
--		mass				= 157.85,
		mass				= 161.48,
		caliber				= 0.178,
		wind_sigma			= 0.0,
		wind_time			= 0.0,
		tail_first			= 0,
		fins_part_val		= 0,
		rotated_fins_inp	= 0,
		delta_max			= math.rad(20),
		draw_fins_conv		= {math.rad(90),1,1},
		L					= 0.178,
		S					= 0.0248,
		Ix					= 1.24,
		Iy					= 130.12,
		Iz					= 130.12,

		Mxd					= 0.1 * 57.3,
		Mxw					= -15.8,

		table_scale	= 0.2,
		table_degree_values = 1,
	--	Mach	  | 0.0		0.2		0.4		0.6		0.8		1.0		1.2		1.4		1.6		1.8		2.0		2.2		2.4		2.6		2.8		3.0		3.2		3.4		3.6		3.8		4.0	 	4.2		4.4		4.6		4.8		5.0 |
		Cx0 	= {	0.515,	0.515,	0.515,	0.515,	0.527,	0.85,	0.949,	0.905,	0.8605,	0.8094,	0.7636,	0.7204,	0.6813,	0.6458,	0.6135,	0.5839,	0.5567,	0.5316,	0.5082,	0.4864,	0.4659,	0.4468,	0.4288,	0.4121,	0.3968,	0.384  },
		CxB 	= {	0.021,	0.021,	0.021,	0.021,	0.021,	0.138,	0.153,	0.146,	0.1382,	0.1272,	0.1167,	0.1073,	0.0987,	0.0909,	0.0837,	0.077,	0.0708,	0.065,	0.0595,	0.0544,	0.0495,	0.0449,	0.0406,	0.0364,	0.0324,	0.0286 },
		K1		= { 0.0039,	0.0039,	0.0039,	0.0039,	0.0039,	0.0048,	0.004,	0.00325,	0.002845,	0.002602,	0.002378,	0.002176,	0.001994,	0.001832,	0.001689,	0.001564,	0.001456,	0.001366,	0.00129,	0.001229,	0.001182,	0.001147,	0.001123,	0.001108,	0.001101,	0.0011 },
		K2		= { -0.0041,-0.0041,-0.0041,-0.0041,-0.0041,-0.0049,-0.0042,-0.0036,	-0.003121,	-0.002725,	-0.002408,	-0.00213,	-0.001888,	-0.001677,	-0.001494,	-0.001334,	-0.001196,	-0.001077,	-0.000973,	-0.000884,	-0.000808,	-0.000743,	-0.000689,	-0.000646,	-0.000615,	-0.0006 },
		Cya		= { 0.345,	0.345,	0.345,	0.345,	0.357,	0.401,	0.448,	0.495,	0.513,	0.506,	0.5,	0.495,	0.49,	0.486,	0.482,	0.478,	0.474,	0.471,	0.468,	0.465,	0.462,	0.46,	0.457,	0.455,	0.453,	0.451 },
		Cza		= { 0.345,	0.345,	0.345,	0.345,	0.357,	0.401,	0.448,	0.495,	0.513,	0.506,	0.5,	0.495,	0.49,	0.486,	0.482,	0.478,	0.474,	0.471,	0.468,	0.465,	0.462,	0.46,	0.457,	0.455,	0.453,	0.451 },
		Mya		= { -1.316,-1.316,	-1.316,	-1.316,	-1.458,	-1.982,	-1.418,	-1.0883,-0.9411,-0.8255,-0.733,	-0.6574,-0.5942,-0.5403,-0.4935,-0.4525,-0.4164,-0.3846,-0.3568,-0.3328,-0.3125,-0.2959,-0.283,-0.2739,-0.2683,-0.2665 },
		Mza		= { -1.316,-1.316,	-1.316,	-1.316,	-1.458,	-1.982,	-1.418,	-1.0883,-0.9411,-0.8255,-0.733,	-0.6574,-0.5942,-0.5403,-0.4935,-0.4525,-0.4164,-0.3846,-0.3568,-0.3328,-0.3125,-0.2959,-0.283,-0.2739,-0.2683,-0.2665 },
		Myw		= { -16.3145,-16.3145,-16.3145,-16.3145,-16.8944,-19.8659,-18.1868,-17.1716,-16.504,-15.88,-15.2958,-14.7478,-14.2328,-13.7477,-13.2901,-12.8574,-12.4477,-12.0593,-11.6911,-11.3421,-11.0121,-10.7015,-10.4118,-10.1458,-9.9098,-9.7256 },
		Mzw		= { -16.3145,-16.3145,-16.3145,-16.3145,-16.8944,-19.8659,-18.1868,-17.1716,-16.504,-15.88,-15.2958,-14.7478,-14.2328,-13.7477,-13.2901,-12.8574,-12.4477,-12.0593,-11.6911,-11.3421,-11.0121,-10.7015,-10.4118,-10.1458,-9.9098,-9.7256 },
		A1trim	= { 24,		24,		24,		24,		23.5,	23,		25.16,	27.23,	29.04,	30.6,	31.93,	33.08,	34.07,	34.95,	35.74,	36.45,	37.09,	37.68,	38.2,	38.66,	39.06,	39.39,	39.66,	39.85,	39.96,	40 },
		A2trim	= { 24,		24,		24,		24,		23.5,	23,		25.16,	27.23,	29.04,	30.6,	31.93,	33.08,	34.07,	34.95,	35.74,	36.45,	37.09,	37.68,	38.2,	38.66,	39.06,	39.39,	39.66,	39.85,	39.96,	40 },

		model_roll = math.rad(45),
		fins_stall = 1,
	},

	sensor = {
		delay						= 1.5,
		op_time						= 200,
		FOV							= math.rad(15),
		max_w_LOS					= math.rad(30),
		sens_near_dist				= 100,
		sens_far_dist				= 30000,
		ccm_k0						= 0.001,		--NIGHTSTORM 0.2,
		aim_sigma					= 2.0,			--NIGHTSTORM 4.0,
		height_error_k				= 10,			--NIGHTSTORM 25
		height_error_max_vel		= 30,			--NIGHTSTORM 60
		height_error_max_h			= 250,			--NIGHTSTORM 300
		hoj							= 1,
		doppler_bandwith            = 12096,  		--NIGHTSTORM To decrease the chances of loosing lock (Thanks Snowywolf!)
	},

	gimbal = {
		delay				= 0,
		op_time				= 200,
		pitch_max			= math.rad(60),
		yaw_max				= math.rad(60),
		max_tracking_rate	= math.rad(30),
		tracking_gain		= 50,
	},

	autopilot = {
		delay				= 0.2,
		cmd_delay 			= 0.8,
		op_time				= 200,
		Tf					= 0.1,
		Knav				= 4.0,
		Kd					= 110.0,
		Ka					= 22.0,
		T1					= 292.0,
		Tc					= 0.04,
		Kx					= 0.1,
		Krx					= 2.0,
		gload_limit			= 40.0,			--NIGHTSTORM 30.0,
		fins_limit			= math.rad(18),
		fins_limit_x		= math.rad(5),
		null_roll			= math.rad(45),
		accel_coeffs		= { 0, 3.4, -0.4, -0.2, 13.6,
								0.0248 * 1.0 * 0.009 },

		loft_active			= 1,
		loft_factor			= 1.5,			--NIGHTSTORM 4.5,
		loft_sin			= math.sin(30/57.3),
		loft_off_range		= 15000,
		dV0					= 347,
	},

	actuator = {
		Tf					= 0.005,
		D					= 250.0,
		T1					= 0.002,
		T2					= 0.006,
		max_omega			= math.rad(400),
		max_delta			= math.rad(20),
		fin_stall			= 1,
		sim_count			= 4,
	},

	proximity_fuze = {
		radius		= 20.0,
		arm_delay	= 1.6,
	},
	
	warhead 	= predefined_warhead("AIM_120C"),
	warhead_air = predefined_warhead("AIM_120C"),
	
}

declare_weapon(AIM_120B)

local AIM_120C = 
{
    category		= CAT_AIR_TO_AIR,
	name			= "AIM_120C",
	displayName		= _("AIM-120C AMRAAM - Active Radar AAM"),
	user_name		= _("AIM-120C"),
	Picture			= "us_AIM-120C.png",	--NIGHTSTORM	
--	display_name_short = "AIM-120",
	display_name_short = "AIM-120C",	--NIGHTSTORM
	scheme			= "aa_missile_amraam2",
	class_name		= "wAmmunitionSelfHoming",
	model			= "aim-120c",
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,AIM_120C},
	
	shape_table_data =
	{
		{
			file  = "aim-120c";
			life  = 1;
			fire  = {0, 1};
			name  	 = "AIM-120C";
			username = "AIM-120C";
			index 	 = AIM_120C,
		},
	},
		
    Escort = 0,				--0-No, 1-La launch, 2-other La, 3-C ground
    Head_Type = 2,			--1-InfraredSeeker, 2-ActiveRadar, 3-AntiRadar, 4-Laserhooming, 5-Autopilot (GPS, TV, IIR), 6-SemiActiveRadar, 7-SemiAutoAT (control from platform)
	sigma = {1, 1, 1},		-- Sigma = {x, y, z}, maximum aiming error in meters, in target coordinates. X-longitudinal axis of the target, y-axis virtualna purpose, Z - axis, transverse target	--NIGHTSTORM {5, 5, 5},
    M = 161.48,				--Gross weight in kg
    H_max = 26000.0,		--Maximum flight altitude in meters. 18Km=59100feet 20km = 65600
    H_min = 1.0,			--Minimum flight height in meters.
    Diam = 178.0,			--Case Diameter in mm
    Cx_pil = 2.5,			--Cx as suspension (Drag value is assumed)		
	D_max = 49600.0,		--Maximum Launch range at low altitude in meters
	D_min = 700.0,			--Minimum Launch range at low altitude in meters
    Head_Form = 1,			--False - hemispherical head shape / True-animate (~conic)
    Life_Time = 150.0,		--Lifetime (self-destruct timer), sec		
    Nr_max = 40,			--Maximum overload during turns		
    v_min = 140.0,	  		-- Minimum speed
    v_mid = 2000.0,	  		-- Average Speed
    Mach_max = 4.5,			--Maximum Mach number
    t_b = 0.5,				--Engine start time
    t_acc = 2.3,			--Time of operation of the accelerator
    t_marsh = 11.0,			--Operating time in marching mode	
    Range_max = 120000.0,	--Maximum launch range at maximum altitude (65NM)
    H_min_t = 1.0,			--Minimum height of the target above the terrain in meters	
    Fi_start = 0.88,		--Angle of tracking and sighting at launch (Angle off boresight)
    Fi_rak = 3.14152,		--Acceptable angle of view of the target (radians)
    Fi_excort = 1.05,		--Angle of tracking (sight) of the target by the missile. (Gimbal Angle Limit)
    Fi_search = 1.05,		--Limit angle of free search (Field of View)
    OmViz_max = 0.70,		--Maximum line-of-sight speed (Gimbl Ang Rate Lim 63°/s)
    exhaust = {0.8, 0.8, 0.8, 0.05 };	--Exhaust definition
    X_back = -1.98,			--X coordinates of the nozzle center in the rocket axes 
    Y_back = 0.0,			--Y coordinates of the nozzle center in the rocket axes
    Z_back = 0.0,			--Z coordinates of the nozzle center in the rocket axes
    Reflection = 0.07,	--Effective radio reflection surface, square meters (RADAR cross section)
    KillDistance = 20.0,	--Distance is used to start the fuse
	
	SeekerGen = 4,  -- Seeker generation
	ccm_k0 = 0.001,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	loft = 1,				--Can missile loft to target based on range 0/1
	hoj = 1,				--Can missile home on an active jamming source 0/1
	loft_factor = 1.5,		--NIGHTSTORM Reduced loft factor from 4.5 for new seeker code to avoid overshoot.
	PN_gain = 6,		--NIGHTSTORM 4
		
	supersonic_A_coef_skew = 0.1, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.02322576, -- площадь выходного сечения сопла		--NIGHTSTORM 0.011,
		
		ModelData = {   58 ,  -- model params count
						0.4 ,   -- characteristic square (характеристическая площадь)
						
						-- Drag (Сx)  
						0.029 , -- Cx_k0 Cd0 at low mach ( M << 1) 
						0.06 , -- Cx_k1 Peak Cd0 value 
						0.01 , -- Cx_k2 steepness of the drag curve before the transonic wave crisis 
						-0.245, -- Cx_k3 Cd0 at high mach (M>>1)
						0.08 , -- Cx_k4 steepness of the drag curve after the transonic wave crisis  
						0.7 , --“polar dump factor"
						
						-- Lift (Cy) 
						1.40 , -- Cy_k0 Clmax at low mach ( M << 1)
						0.60 , -- Cy_k0 Clmax at high mach ( M >> 1)
						1.2  , -- Cy_k2 steepness of the lift curve after the transonic wave crisis  
						
						0.5 , -- alpha max
						5.0, --Additional g’s due to thrust vectoring/rocket motors 
						
					-- Engine data. Time, fuel flow, thrust.	
					--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end		-- Stage
						-1.0,	   	0.5,	2.3,		11.0,		0.0,			0.0,		1.0e9,		-- time of stage, sec
						 0.0,		0.0,	8.8,		4.08,		0.0,			0.0,		0.0,		-- fuel flow rate in second, kg/sec
						 0.0,		0.0,	20392.9,	9360.4,		0.0,			0.0,		0.0,		-- thrust, newtons

						 1.0e9, -- таймер самоликвидации, сек
						 150.0, -- lifetime in seconds							 
						 0, -- Minimum height in M
						 1.0, -- Autopilot delay, sec			--NIGHTSTORM 0.2
						 25000.0, -- Lofting logic Rmin 
						 15000.0, -- Range to target at which loft is complete (must be larger than previous value) in meters
						 0.52356,	-- Angle in radians of loft 
						 50.0, -- longitudinal acceleration of fuse cocking
						 0.0, -- speed module communicated by a catapult device, expelling charge, etc.
						 1.19, -- characteristic of the SAU-RAKETA system, second-order filter coefficient K0
						 1.0, -- characteristic of the SAU-Raketa system, second order filter coefficient K1
						 2.0, -- characteristic of the SAU-RAKETA system, control loop bandwidth

					-- DLZ. Data for calculating launch ranges (indication on the sight)
						21.0, 		-- range with respect to carrier speed at an altitude of 1 km
						-23.0, 		-- range with respect to target speed at an altitude of 1 km
						-3.0, 		-- derivative with respect to height of derivative of range with respect to target speed
						72800.0, 	-- range angle 180 degrees (towards), H = 5,000m, V = 900km / h, m	H = 16,404ft V = 486kts (39.31nm)
						24800.0, 	-- range angle 0 (in pursuit) deg, H = 5,000m, V = 900km / h, m	 H = 16,404ft V = 486kts (13.39nm)
						120000.0, 	-- range angle 180 (towards) deg, H = 10,000m, V = 900km / h, m  H = 32,808ft, V = 486kts  (64.8nm)
						47200.0,  	-- range angle 0 (in pursuit) deg, H = 10,000m, V = 900km / h, m H = 32,808ft, V = 486kts  (25.49nm)
						49600.0, 	-- range angle 180 (towards) deg, H = 1,000m, V = 900km / h, m	  H = 3,281ft, V = 486kts (26.78nm)
						14400.0, 	-- range angle 0 (in pursuit) deg, H = 1,000m, V = 900km / h, m	   H = 3,281ft, V = 486kts (7.78nm)
						4000.0, 	-- backward offset from the backsight point of the reachable zone
						0.40, 		-- percentage of guaranteed range from range in PPS at an altitude of 1 km
						-0.015, 	-- derivative of the percentage of guaranteed range in PPP by height
						0.5, 		-- Changing the slope coefficients of the curve in the upper and lower hemispheres from the height of the carrier.

					}, 
	
	controller = {
		boost_start = 0.5,
		march_start = 2.8,
	},

--Thrust value = impulse x fuel mass x 9.8 / burn time  

	boost = {
		impulse								= 236,
		fuel_mass							= 20.28,
		work_time							= 2.3,
		nozzle_position						= {{-1.9, 0, 0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		nozzle_exit_area 					= 0.02322576,
		tail_width							= 0.4,
		smoke_color							= {0.8, 0.8, 0.8},
		smoke_transparency					= 0.03,
		custom_smoke_dissipation_factor		= 0.2,
		smoke_opacity_type 					= 1,
	},

	march = {
		impulse								= 234,
		fuel_mass							= 44.9,
		work_time							= 11,
		nozzle_position						= {{-1.9, 0, 0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		nozzle_exit_area 					= 0.02322576,
		tail_width							= 0.4,
		smoke_color							= {0.8, 0.8, 0.8},
		smoke_transparency					= 0.03,
		custom_smoke_dissipation_factor		= 0.2,
		smoke_opacity_type 					= 1,		
	},	

	fm = {
		mass				= 161.48,
		caliber				= 0.178,
		wind_sigma			= 0.0,
		wind_time			= 0.0,
		tail_first			= 0,
		fins_part_val		= 0,
		rotated_fins_inp	= 0,
		delta_max			= math.rad(20),
		draw_fins_conv		= {math.rad(90),1,1},
		L					= 0.178,
		S					= 0.0248,
		Ix					= 1.24,
		Iy					= 130.12,
		Iz					= 130.12,

		Mxd					= 0.1 * 57.3,
		Mxw					= -15.8,

		table_scale	= 0.2,
		table_degree_values = 1,
	--	Mach	  | 0.0		0.2		0.4		0.6		0.8		1.0		1.2		1.4		1.6		1.8		2.0		2.2		2.4		2.6		2.8		3.0		3.2		3.4		3.6		3.8		4.0	 	4.2		4.4		4.6		4.8		5.0 |
		Cx0 	= {	0.515,	0.515,	0.515,	0.515,	0.527,	0.85,	0.949,	0.905,	0.8605,	0.8094,	0.7636,	0.7204,	0.6813,	0.6458,	0.6135,	0.5839,	0.5567,	0.5316,	0.5082,	0.4864,	0.4659,	0.4468,	0.4288,	0.4121,	0.3968,	0.384  },
		CxB 	= {	0.021,	0.021,	0.021,	0.021,	0.021,	0.138,	0.153,	0.146,	0.1382,	0.1272,	0.1167,	0.1073,	0.0987,	0.0909,	0.0837,	0.077,	0.0708,	0.065,	0.0595,	0.0544,	0.0495,	0.0449,	0.0406,	0.0364,	0.0324,	0.0286 },
		K1		= { 0.0039,	0.0039,	0.0039,	0.0039,	0.0039,	0.0048,	0.004,	0.00325,	0.002845,	0.002602,	0.002378,	0.002176,	0.001994,	0.001832,	0.001689,	0.001564,	0.001456,	0.001366,	0.00129,	0.001229,	0.001182,	0.001147,	0.001123,	0.001108,	0.001101,	0.0011 },
		K2		= { -0.0041,-0.0041,-0.0041,-0.0041,-0.0041,-0.0049,-0.0042,-0.0036,	-0.003121,	-0.002725,	-0.002408,	-0.00213,	-0.001888,	-0.001677,	-0.001494,	-0.001334,	-0.001196,	-0.001077,	-0.000973,	-0.000884,	-0.000808,	-0.000743,	-0.000689,	-0.000646,	-0.000615,	-0.0006 },
		Cya		= { 0.345,	0.345,	0.345,	0.345,	0.357,	0.401,	0.448,	0.495,	0.513,	0.506,	0.5,	0.495,	0.49,	0.486,	0.482,	0.478,	0.474,	0.471,	0.468,	0.465,	0.462,	0.46,	0.457,	0.455,	0.453,	0.451 },
		Cza		= { 0.345,	0.345,	0.345,	0.345,	0.357,	0.401,	0.448,	0.495,	0.513,	0.506,	0.5,	0.495,	0.49,	0.486,	0.482,	0.478,	0.474,	0.471,	0.468,	0.465,	0.462,	0.46,	0.457,	0.455,	0.453,	0.451 },
		Mya		= { -1.316,-1.316,	-1.316,	-1.316,	-1.458,	-1.982,	-1.418,	-1.0883,-0.9411,-0.8255,-0.733,	-0.6574,-0.5942,-0.5403,-0.4935,-0.4525,-0.4164,-0.3846,-0.3568,-0.3328,-0.3125,-0.2959,-0.283,-0.2739,-0.2683,-0.2665 },
		Mza		= { -1.316,-1.316,	-1.316,	-1.316,	-1.458,	-1.982,	-1.418,	-1.0883,-0.9411,-0.8255,-0.733,	-0.6574,-0.5942,-0.5403,-0.4935,-0.4525,-0.4164,-0.3846,-0.3568,-0.3328,-0.3125,-0.2959,-0.283,-0.2739,-0.2683,-0.2665 },
		Myw		= { -16.3145,-16.3145,-16.3145,-16.3145,-16.8944,-19.8659,-18.1868,-17.1716,-16.504,-15.88,-15.2958,-14.7478,-14.2328,-13.7477,-13.2901,-12.8574,-12.4477,-12.0593,-11.6911,-11.3421,-11.0121,-10.7015,-10.4118,-10.1458,-9.9098,-9.7256 },
		Mzw		= { -16.3145,-16.3145,-16.3145,-16.3145,-16.8944,-19.8659,-18.1868,-17.1716,-16.504,-15.88,-15.2958,-14.7478,-14.2328,-13.7477,-13.2901,-12.8574,-12.4477,-12.0593,-11.6911,-11.3421,-11.0121,-10.7015,-10.4118,-10.1458,-9.9098,-9.7256 },
		A1trim	= { 24,		24,		24,		24,		23.5,	23,		25.16,	27.23,	29.04,	30.6,	31.93,	33.08,	34.07,	34.95,	35.74,	36.45,	37.09,	37.68,	38.2,	38.66,	39.06,	39.39,	39.66,	39.85,	39.96,	40 },
		A2trim	= { 24,		24,		24,		24,		23.5,	23,		25.16,	27.23,	29.04,	30.6,	31.93,	33.08,	34.07,	34.95,	35.74,	36.45,	37.09,	37.68,	38.2,	38.66,	39.06,	39.39,	39.66,	39.85,	39.96,	40 },

		model_roll = math.rad(45),
		fins_stall = 1,
	},

	sensor = {
		delay						= 1.5,
		op_time						= 150,
		FOV							= math.rad(15),
		max_w_LOS					= math.rad(30),
		sens_near_dist				= 100,
		sens_far_dist				= 30000,
		ccm_k0						= 0.001,		--NIGHTSTORM 0.2,
		aim_sigma					= 2.0,			--NIGHTSTORM 4.0,
		height_error_k				= 25,
		height_error_max_vel		= 60,
		height_error_max_h			= 300,
		hoj							= 1,
		doppler_bandwith            = 12096,  		--NIGHTSTORM To decrease the chances of loosing lock (Thanks Snowywolf!)		
	},
	
	gimbal = {
		delay				= 0,
		op_time				= 150,
		pitch_max			= math.rad(60),
		yaw_max				= math.rad(60),
		max_tracking_rate	= math.rad(30),
		tracking_gain		= 50,
	},

	autopilot = {
		delay				= 0.2,
		cmd_delay			= 0.8,
		op_time				= 150,
		Tf					= 0.1,
		Knav				= 4.0,
		Kd					= 180.0,
		Ka					= 16.0,
		T1					= 309.0,
		Tc					= 0.06,
		Kx					= 0.1,
		Krx					= 2.0,
		gload_limit			= 40.0,
		fins_limit			= math.rad(18),
		fins_limit_x		= math.rad(5),
		null_roll			= math.rad(45),
		accel_coeffs		= { 0, 3.4, -0.4, -0.2, 13.6,
								0.0248 * 1.0 * 0.009 },

		loft_active			= 1,
		loft_factor			= 1.5,			--NIGHTSTORM 4.5,
		loft_sin			= math.sin(30/57.3),
		loft_off_range		= 15000,
		dV0					= 393,
	},

	actuator = {
		Tf					= 0.005,
		D					= 250.0,
		T1					= 0.002,
		T2					= 0.006,
		max_omega			= math.rad(400),
		max_delta			= math.rad(20),
		fin_stall			= 1,
		sim_count			= 4,
	},

	proximity_fuze = {
		radius		= 20.0,
		arm_delay	= 1.6,
	},

	warhead		= predefined_warhead("AIM_120C"),
	warhead_air = predefined_warhead("AIM_120C"),
}

declare_weapon(AIM_120C)

local aim120_variants =
{
--	["AIM-120"]  		= {display_name = AIM_120B.displayName, Picture	=	"us_AIM-120B.png", PictureBlendColor = "0xffffffff", wstype = AIM_120B.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = AIM_120B.M},
	["AIM-120D"]  		= {display_name = AIM_120B.displayName, Picture	=	"us_AIM-120D.png", PictureBlendColor = "0xffffffff", wstype = AIM_120B.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = AIM_120B.M},	--NIGHTSTORM
	["AIM-120C"] 		= {display_name = AIM_120C.displayName, Picture	=	"us_AIM-120C.png", PictureBlendColor = "0xffffffff", wstype = AIM_120C.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = AIM_120C.M},
}

local function lau_115_2x127_amraam(clsid,element,left,right)
	local var 	   = aim120_variants[element] or aim120_variants["AIM-120"]
	local var_mass = var.mass or 160
	
	local sz = 0
	if left then 	sz = sz +1 end
	if right then	sz = sz +1 end

	local ret = {
		category			=	var.category,
		CLSID				=	clsid,
		Picture				=	var.Picture,
        PictureBlendColor   =   var.PictureBlendColor,
		wsTypeOfWeapon		=	var.wstype,
		attribute			=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
		Count				=	sz,
		Weight_Empty		=	lau115_weight + lau127_weight * 2,
		Weight				=	lau115_weight + lau127_weight * 2 + var_mass * sz,
		Cx_pil				=	0.000739765625 + sz * 0.00061,
		Elements 			= {{ShapeName	=	"LAU-115C+2_LAU127",IsAdapter  	   =   true  }}
	}
	if left then 	ret.Elements[#ret.Elements + 1] = {ShapeName	    =	 element,connector_name =	"Point03" }	end --rotation because LAU-127 have bugged connector pos
	if right then	ret.Elements[#ret.Elements + 1] = {ShapeName		=	 element,connector_name =	"Point02" }	end --rotation because LAU-127 have bugged connector pos
	

	if sz > 1 then
		ret.displayName =	_("LAU-115 with").." 2 x LAU-127 "..var.display_name
	else
		ret.displayName =	_("LAU-115 with").." 1 x LAU-127 "..var.display_name
	end
	declare_loadout(ret)
end

local function amraam_without_adapter(CLSID,variant)
	local var = aim120_variants[variant] or aim120_variants["AIM-120"]
	local var_mass = var.mass or 160
	declare_loadout({
		category			= 	var.category,
		CLSID 				= 	CLSID,
		Picture				=	var.Picture,
        PictureBlendColor   =   var.PictureBlendColor,
		displayName			=	var.display_name,
		attribute			=	var.wstype,
		Cx_pil				=	0.00061,
		Count				=	1,
		Weight				=	var_mass,
		Elements			=  {{ShapeName = variant}}-- end of Elements
	})
end

--amraam_without_adapter("{C8E06185-7CD6-4C90-959F-044679E90751}", "AIM-120")	--NIGHTSTORM
amraam_without_adapter("{C8E06185-7CD6-4C90-959F-044679E90751}", "AIM-120D")
amraam_without_adapter("{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", "AIM-120C")

--lau_115_2x127_amraam("LAU-115_2*LAU-127_AIM-120B"	,"AIM-120",true,true)	--NIGHTSTORM
lau_115_2x127_amraam("LAU-115_2*LAU-127_AIM-120B"	,"AIM-120D",true,true)
lau_115_2x127_amraam("LAU-115_2*LAU-127_AIM-120C"	,"AIM-120C",true,true)

--lau_115_2x127_amraam("{LAU-115 - AIM-120B}"		,"AIM-120",true,false)	--NIGHTSTORM
lau_115_2x127_amraam("{LAU-115 - AIM-120B}"		,"AIM-120D",true,false)
lau_115_2x127_amraam("{LAU-115 - AIM-120C}"		,"AIM-120C",true,false)

--lau_115_2x127_amraam("{LAU-115 - AIM-120B_R}"	,"AIM-120",false,true)	--NIGHTSTORM
lau_115_2x127_amraam("{LAU-115 - AIM-120B_R}"	,"AIM-120D",false,true)
lau_115_2x127_amraam("{LAU-115 - AIM-120C_R}"	,"AIM-120C",false,true)
